<?php
// webhook.php - Updated with token support (16 Toko Fokus NBR removed)
require_once 'config.php';
require_once 'start.php';
require_once 'tambah-pengguna.php';
require_once 'hapus-pengguna.php';
require_once 'nkl.php'; 
require_once 'nbr.php';
require_once 'detail-nkl.php';
require_once 'detail-nbr.php';
require_once 'trend.php';
// require_once '16-toko-fokus-nbr.php'; // DIHAPUS
require_once 'buat-token.php'; // Include file token baru
require_once 'panduan.php';

// Ambil input dari Telegram
$input = file_get_contents('php://input');
$update = json_decode($input, true);

// Log untuk debugging (opsional)
file_put_contents('bot_log.txt', date('Y-m-d H:i:s') . " - " . $input . "\n", FILE_APPEND);

if (isset($update['message'])) {
    $message = $update['message'];
    $chat_id = $message['chat']['id'];
    $telegram_id = $message['from']['id'];
    $text = isset($message['text']) ? trim($message['text']) : '';
    
    // Handle command /start
    if ($text === '/start') {
        handleStart($telegram_id, $chat_id);
    }
    // Handle Buat Token feature - untuk Admin only
    else if ($text === '🔑 Buat Token' || $text === 'Buat Token') {
        handleBuatToken($telegram_id, $chat_id, $text);
    }
    // Handle Panduan feature
    else if ($text === '📚 Panduan Pengguna dan Admin' || $text === 'Panduan Pengguna dan Admin') {
        handlePanduan($telegram_id, $chat_id, $text);
    }
    // Handle NKL feature
    else if ($text === '📁 NKL' || $text === 'NKL' || strtolower($text) === 'nkl') {
        handleNKL($telegram_id, $chat_id, $text);
    }
    // Handle NBR feature
    else if ($text === '📁 NBR' || $text === 'NBR' || strtolower($text) === 'nbr') {
        handleNBR($telegram_id, $chat_id, $text);
    }
    // Handle Detail NKL feature
    else if ($text === '📋 Detail NKL' || $text === 'Detail NKL' || strtolower($text) === 'detail nkl') {
        handleDetailNKL($telegram_id, $chat_id, $text);
    }
    // Handle Detail NBR feature
    else if ($text === '📋 Detail NBR' || $text === 'Detail NBR' || strtolower($text) === 'detail nbr') {
        handleDetailNBR($telegram_id, $chat_id, $text);
    }
    // Handle TREND feature
    else if ($text === '📈 TREND' || $text === 'TREND' || strtolower($text) === 'trend') {
        handleTREND($telegram_id, $chat_id, $text);
    }
    // Handle reply keyboard messages
    else if ($text === '➕ Tambah Pengguna' || $text === 'Tambah Pengguna') {
        handleTambahPengguna($telegram_id, $chat_id, $text);
    }
    // Handle Hapus Pengguna
    else if ($text === '❌ Hapus Pengguna' || $text === 'Hapus Pengguna') {
        handleHapusPengguna($telegram_id, $chat_id, $text);
    }
    // Handle Info Akun
    else if ($text === 'ℹ️ Info Akun' || $text === 'Info Akun') {
        $user = isUserRegistered($telegram_id);
        if ($user) {
            $db = getDB();
            $stmt = $db->prepare("SELECT * FROM users WHERE telegram_id = ?");
            $stmt->execute([$telegram_id]);
            $user_data = $stmt->fetch(PDO::FETCH_ASSOC);
            
            $info_text = "📋 <b>Info Akun Anda:</b>\n\n";
            $info_text .= "👤 Nama: {$user_data['nama_depan']} {$user_data['nama_belakang']}\n";
            $info_text .= "🆔 ID Telegram: {$user_data['telegram_id']}\n";
            $info_text .= "👑 Role: {$user_data['role']}\n";
            $info_text .= "📅 Terdaftar: " . date('d M Y H:i', strtotime($user_data['created_at'])) . "\n";
            
            sendMessage($chat_id, $info_text);
        } else {
            sendMessage($chat_id, "❌ Anda belum terdaftar dalam sistem.");
        }
    }
    // Handle Menu Utama
    else if ($text === '🏠 Menu Utama' || $text === 'Menu Utama') {
        sendMessage($chat_id, "🏠 Anda berada di Menu Utama. Silakan pilih fitur yang tersedia pada keyboard di bawah.");
    }
    // Handle input untuk proses tambah pengguna, hapus pengguna, atau token
    else {
        // Cek apakah user terdaftar dulu
        $user = isUserRegistered($telegram_id);
        
        // Jika user tidak terdaftar, cek apakah input adalah token
        if (!$user) {
            // Cek apakah text seperti token (huruf besar dan angka, panjang sekitar 10 karakter)
            if (preg_match('/^[A-Z0-9]{8,12}$/', strtoupper($text))) {
                handleTokenInput($telegram_id, $chat_id, $text);
            } else {
                sendMessage($chat_id, "❌ Maaf, Anda belum terdaftar untuk menggunakan bot ini. Silakan hubungi admin untuk mendaftar.\n\n🔑 Jika Anda mempunyai token, silakan kirim token tersebut.");
            }
            return;
        }
        
        $temp_data = getTemporaryData($telegram_id);
        if (!empty($temp_data) && isset($temp_data['step'])) {
            // Cek apakah ini untuk proses tambah pengguna
            if (strpos($temp_data['step'], 'nama_depan') === 0 || 
                strpos($temp_data['step'], 'nama_belakang') === 0 || 
                strpos($temp_data['step'], 'telegram_id') === 0 || 
                strpos($temp_data['step'], 'role') === 0) {
                handleTambahPengguna($telegram_id, $chat_id, $text);
            }
            // Cek apakah ini untuk proses hapus pengguna
            else if (strpos($temp_data['step'], 'hapus_pengguna') === 0) {
                handleHapusPengguna($telegram_id, $chat_id, $text);
            } else {
                // Clear invalid temp data dan kirim pesan default
                clearTemporaryData($telegram_id);
                sendMessage($chat_id, "❓ Maaf, saya tidak mengerti pesan Anda. Silakan gunakan keyboard yang tersedia atau ketik /start untuk memulai.");
            }
        } else {
            // Pesan default untuk text yang tidak dikenali
            sendMessage($chat_id, "❓ Maaf, saya tidak mengerti pesan Anda. Silakan gunakan keyboard yang tersedia atau ketik /start untuk memulai.");
        }
    }
}

// Handle callback query (inline keyboard)
if (isset($update['callback_query'])) {
    $callback_query = $update['callback_query'];
    $chat_id = $callback_query['message']['chat']['id'];
    $telegram_id = $callback_query['from']['id'];
    $callback_data = $callback_query['data'];
    
    // Handle konfirmasi pendaftaran pengguna
    if ($callback_data === 'confirm_register' || $callback_data === 'cancel_register') {
        handleConfirmRegister($telegram_id, $chat_id, $callback_data);
    }
    
    // Handle konfirmasi penghapusan pengguna
    if ($callback_data === 'confirm_delete' || $callback_data === 'cancel_delete') {
        handleConfirmDelete($telegram_id, $chat_id, $callback_data);
    }
    
    // Handle TREND callback queries
    if (strpos($callback_data, 'trend_') === 0) {
        handleTRENDCallback($telegram_id, $chat_id, $callback_data);
    }
    
    // Handle 16 Toko Fokus NBR callback queries - DIHAPUS
    /*
    if (strpos($callback_data, '16toko_') === 0) {
        handle16TokoCallback($telegram_id, $chat_id, $callback_data);
    }
    */
    
    // Handle create token callback queries
    if (strpos($callback_data, 'create_token_') === 0 || $callback_data === 'cancel_create_token') {
        handleCreateTokenCallback($telegram_id, $chat_id, $callback_data);
    }

    // Handle panduan callback queries
    if (strpos($callback_data, 'panduan_') === 0) {
        handlePanduanCallback($telegram_id, $chat_id, $callback_data);
    }
    
    // Answer callback query untuk menghilangkan loading
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, API_URL . 'answerCallbackQuery');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, ['callback_query_id' => $callback_query['id']]);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);
}

http_response_code(200);
?>