<?php
// tambah-pengguna.php
require_once 'config.php';

function handleTambahPengguna($telegram_id, $chat_id, $message_text) {
    // Cek apakah user adalah admin
    $user_role = getUserRole($telegram_id);
    if ($user_role !== 'Admin') {
        sendMessage($chat_id, "❌ Maaf, fitur ini hanya tersedia untuk Admin.");
        return;
    }
    
    // Ambil data sementara
    $temp_data = getTemporaryData($telegram_id);
    
    // Jika baru memulai proses tambah pengguna - DIPERBAIKI
    if ($message_text === '➕ Tambah Pengguna' || $message_text === 'Tambah Pengguna') {
        // Reset data sementara
        clearTemporaryData($telegram_id);
        
        sendMessage($chat_id, "Wah, kamu mau mendaftar pengguna ya? yuk isi dulu datanya");
        sendMessage($chat_id, "Nama Depan Pendaftar:");
        
        // Set status untuk step berikutnya
        saveTemporaryData($telegram_id, ['step' => 'nama_depan']);
        return;
    }
    
    // Proses berdasarkan step
    $step = isset($temp_data['step']) ? $temp_data['step'] : '';
    
    switch ($step) {
        case 'nama_depan':
            $temp_data['nama_depan'] = $message_text;
            $temp_data['step'] = 'nama_belakang';
            saveTemporaryData($telegram_id, $temp_data);
            
            sendMessage($chat_id, "Nama Belakang Pendaftar:");
            break;
            
        case 'nama_belakang':
            $temp_data['nama_belakang'] = $message_text;
            $temp_data['step'] = 'telegram_id';
            saveTemporaryData($telegram_id, $temp_data);
            
            sendMessage($chat_id, "ID Telegram Pendaftar:");
            break;
            
        case 'telegram_id':
            // Validasi apakah input adalah angka
            if (!is_numeric($message_text)) {
                sendMessage($chat_id, "❌ ID Telegram harus berupa angka. Silakan masukkan ID Telegram yang valid:");
                return;
            }
            
            // Cek apakah ID sudah terdaftar
            if (isUserRegistered($message_text)) {
                sendMessage($chat_id, "❌ ID Telegram tersebut sudah terdaftar. Silakan masukkan ID Telegram lain:");
                return;
            }
            
            $temp_data['telegram_id_pendaftar'] = $message_text;
            $temp_data['step'] = 'role';
            saveTemporaryData($telegram_id, $temp_data);
            
            sendMessage($chat_id, "Role (Member/Admin):");
            break;
            
        case 'role':
            $role = ucfirst(strtolower($message_text));
            
            if ($role !== 'Member' && $role !== 'Admin') {
                sendMessage($chat_id, "❌ Role harus 'Member' atau 'Admin'. Silakan pilih salah satu:");
                return;
            }
            
            $temp_data['role'] = $role;
            $temp_data['step'] = 'konfirmasi';
            saveTemporaryData($telegram_id, $temp_data);
            
            // Tampilkan konfirmasi dengan inline keyboard
            $konfirmasi_text = "📝 <b>Data Pendaftar:</b>\n\n";
            $konfirmasi_text .= "👤 Nama: {$temp_data['nama_depan']} {$temp_data['nama_belakang']}\n";
            $konfirmasi_text .= "🆔 ID Telegram: {$temp_data['telegram_id_pendaftar']}\n";
            $konfirmasi_text .= "👑 Role: {$temp_data['role']}\n\n";
            $konfirmasi_text .= "❓ Apakah Anda yakin mendaftarkan pengguna tersebut?";
            
            $inline_keyboard = [
                'inline_keyboard' => [
                    [
                        ['text' => '✅ Yakin', 'callback_data' => 'confirm_register'],
                        ['text' => '❌ Tidak', 'callback_data' => 'cancel_register']
                    ]
                ]
            ];
            
            sendMessage($chat_id, $konfirmasi_text, $inline_keyboard);
            break;
    }
}

function handleConfirmRegister($telegram_id, $chat_id, $callback_data) {
    // Cek apakah user adalah admin
    $user_role = getUserRole($telegram_id);
    if ($user_role !== 'Admin') {
        return;
    }
    
    $temp_data = getTemporaryData($telegram_id);
    
    if ($callback_data === 'confirm_register') {
        // Simpan ke database
        $db = getDB();
        if ($db) {
            try {
                $stmt = $db->prepare("INSERT INTO users (telegram_id, nama_depan, nama_belakang, role) VALUES (?, ?, ?, ?)");
                $result = $stmt->execute([
                    $temp_data['telegram_id_pendaftar'],
                    $temp_data['nama_depan'],
                    $temp_data['nama_belakang'],
                    $temp_data['role']
                ]);
                
                if ($result) {
                    sendMessage($chat_id, "✅ <b>Pengguna berhasil didaftarkan!</b>\n\n👤 Nama: {$temp_data['nama_depan']} {$temp_data['nama_belakang']}\n🆔 ID Telegram: {$temp_data['telegram_id_pendaftar']}\n👑 Role: {$temp_data['role']}");
                } else {
                    sendMessage($chat_id, "❌ Gagal mendaftarkan pengguna. Silakan coba lagi.");
                }
            } catch (PDOException $e) {
                error_log("Database error: " . $e->getMessage());
                sendMessage($chat_id, "❌ Terjadi kesalahan database. Silakan coba lagi.");
            }
        } else {
            sendMessage($chat_id, "❌ Koneksi database bermasalah. Silakan coba lagi.");
        }
        
        // Hapus data sementara
        clearTemporaryData($telegram_id);
        
    } else if ($callback_data === 'cancel_register') {
        sendMessage($chat_id, "❌ Pendaftaran pengguna dibatalkan.");
        
        // Hapus data sementara
        clearTemporaryData($telegram_id);
    }
    
    // Tampilkan menu utama lagi
    require_once 'start.php';
    handleStart($telegram_id, $chat_id);
}
?>