<?php
// start.php - Updated with token support (16 Toko Fokus NBR removed)
require_once 'config.php';

function handleStart($telegram_id, $chat_id) {
    // Cek apakah user terdaftar
    $user = isUserRegistered($telegram_id);
    
    if (!$user) {
        $message = "❌ Maaf, Anda belum terdaftar untuk menggunakan bot ini. Silakan hubungi admin untuk mendaftar.\n\n";
        $message .= "🔑 Jika Anda mempunyai token, silakan kirim token tersebut.";
        
        sendMessage($chat_id, $message);
        return;
    }
    
    // Pesan sambutan untuk user terdaftar
    $welcome_message = "Hallo!! Saya adalah AIC (Asisten IC) yang akan menyediakan data yang kamu mau, yuk pilih fitur yang kamu mau: ";
    
    // Buat reply keyboard berdasarkan role
    $keyboard = [];
    
    // Fitur untuk semua user
    $keyboard[] = ['🏠 Menu Utama'];
    
    // Fitur NKL, NBR, dan Detail NKL untuk semua user
    $keyboard[] = ['📁 NKL', '📁 NBR'];
    $keyboard[] = ['📋 Detail NKL', '📋 Detail NBR'];
    
    // Fitur TREND untuk semua user - ditambahkan di baris baru
    $keyboard[] = ['📈 TREND'];
    
    // Fitur khusus admin - dalam satu baris horizontal
    if ($user['role'] == 'Admin') {
        $keyboard[] = ['➕ Tambah Pengguna', '❌ Hapus Pengguna'];
        $keyboard[] = ['🔑 Buat Token']; // Tambah fitur Buat Token untuk Admin
    }
    
    $keyboard[] = ['ℹ️ Info Akun'];
    $keyboard[] = ['📚 Panduan Pengguna dan Admin'];
    
    $reply_markup = [
        'keyboard' => $keyboard,
        'resize_keyboard' => true,
        'one_time_keyboard' => false
    ];
    
    sendMessage($chat_id, $welcome_message, $reply_markup);
}
?>