<?php
require_once 'config.php';

// Pastikan URL webhook menggunakan HTTPS dan dapat diakses
$webhook_url = 'https://telegram.icbku.my.id/bot-telegram/webhook.php';

echo "🔍 Checking webhook URL: " . $webhook_url . "\n";

// Cek apakah URL dapat diakses
$ch_test = curl_init();
curl_setopt($ch_test, CURLOPT_URL, $webhook_url);
curl_setopt($ch_test, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch_test, CURLOPT_TIMEOUT, 10);
curl_setopt($ch_test, CURLOPT_FOLLOWLOCATION, true);
curl_setopt($ch_test, CURLOPT_SSL_VERIFYPEER, false); // Temporary for testing
curl_setopt($ch_test, CURLOPT_SSL_VERIFYHOST, false); // Temporary for testing

$test_response = curl_exec($ch_test);
$http_code = curl_getinfo($ch_test, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch_test);
curl_close($ch_test);

if ($curl_error) {
    echo "❌ URL tidak dapat diakses: " . $curl_error . "\n";
    echo "💡 Pastikan:\n";
    echo "   - Domain aktif dan dapat diakses\n";
    echo "   - File webhook.php ada di path yang benar\n";
    echo "   - SSL certificate valid\n";
    exit;
} else {
    echo "✅ URL dapat diakses (HTTP Code: " . $http_code . ")\n";
}

// Hapus webhook yang lama terlebih dahulu
echo "\n🗑️ Menghapus webhook lama...\n";
$delete_data = ['url' => ''];

$ch_delete = curl_init();
curl_setopt($ch_delete, CURLOPT_URL, API_URL . 'deleteWebhook');
curl_setopt($ch_delete, CURLOPT_POST, true);
curl_setopt($ch_delete, CURLOPT_POSTFIELDS, $delete_data);
curl_setopt($ch_delete, CURLOPT_RETURNTRANSFER, true);

$delete_response = curl_exec($ch_delete);
curl_close($ch_delete);

$delete_result = json_decode($delete_response, true);
if ($delete_result['ok']) {
    echo "✅ Webhook lama berhasil dihapus\n";
} else {
    echo "⚠️ Gagal hapus webhook lama: " . $delete_result['description'] . "\n";
}

// Set webhook baru
echo "\n🔧 Setting webhook baru...\n";
$data = [
    'url' => $webhook_url,
    'max_connections' => 40,
    'drop_pending_updates' => true // Hapus update pending yang lama
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, API_URL . 'setWebhook');
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);

$response = curl_exec($ch);
$curl_error = curl_error($ch);
curl_close($ch);

if ($curl_error) {
    echo "❌ Curl Error: " . $curl_error . "\n";
    exit;
}

$result = json_decode($response, true);

echo "\n📋 Response dari Telegram:\n";
echo $response . "\n";

if ($result && $result['ok']) {
    echo "\n✅ Webhook berhasil diset ke: " . $webhook_url . "\n";
} else {
    echo "\n❌ Gagal set webhook\n";
    if (isset($result['description'])) {
        echo "Error: " . $result['description'] . "\n";
    }
    if (isset($result['error_code'])) {
        echo "Error Code: " . $result['error_code'] . "\n";
    }
}

// Cek info webhook
echo "\n🔍 Mengecek info webhook...\n";
$ch_info = curl_init();
curl_setopt($ch_info, CURLOPT_URL, API_URL . 'getWebhookInfo');
curl_setopt($ch_info, CURLOPT_RETURNTRANSFER, true);

$info_response = curl_exec($ch_info);
curl_close($ch_info);

$webhook_info = json_decode($info_response, true);
if ($webhook_info && isset($webhook_info['result'])) {
    echo "\n📋 Info Webhook:\n";
    echo "URL: " . ($webhook_info['result']['url'] ?: 'Tidak ada') . "\n";
    echo "Has custom certificate: " . ($webhook_info['result']['has_custom_certificate'] ? 'Ya' : 'Tidak') . "\n";
    echo "Pending updates: " . $webhook_info['result']['pending_update_count'] . "\n";
    echo "Max connections: " . ($webhook_info['result']['max_connections'] ?? 'Default') . "\n";
    
    if (isset($webhook_info['result']['last_error_date'])) {
        echo "Last error date: " . date('Y-m-d H:i:s', $webhook_info['result']['last_error_date']) . "\n";
        echo "Last error message: " . ($webhook_info['result']['last_error_message'] ?? 'Tidak ada') . "\n";
    }
    
    if (isset($webhook_info['result']['allowed_updates'])) {
        echo "Allowed updates: " . implode(', ', $webhook_info['result']['allowed_updates']) . "\n";
    }
} else {
    echo "❌ Gagal mendapatkan info webhook\n";
}

// Tips troubleshooting
echo "\n💡 Tips Troubleshooting:\n";
echo "1. Pastikan domain menggunakan HTTPS dengan SSL certificate yang valid\n";
echo "2. Pastikan file webhook.php dapat diakses dari internet\n";
echo "3. Pastikan server dapat menerima POST request dari IP Telegram\n";
echo "4. Cek apakah ada firewall yang memblokir akses\n";
echo "5. Pastikan PHP error reporting diaktifkan untuk debugging\n";
?>