<?php
require_once 'config.php';

function handlePanduan($telegram_id, $chat_id, $text) {
    $user = isUserRegistered($telegram_id);
    
    if (!$user) {
        sendMessage($chat_id, "❌ Anda belum terdaftar dalam sistem.");
        return;
    }

    $inline_keyboard = [
        [
            ['text' => '👤 Panduan Pengguna', 'callback_data' => 'panduan_user'],
            ['text' => '⚙️ Panduan Admin', 'callback_data' => 'panduan_admin']
        ],
        [
            ['text' => '🔑 Panduan Token', 'callback_data' => 'panduan_token']
        ],
        [
            ['text' => '❓ FAQ', 'callback_data' => 'panduan_faq']
        ]
    ];
    
    $reply_markup = [
        'inline_keyboard' => $inline_keyboard
    ];
    
    $message = "📚 <b>Panduan Bot AIC (Asisten IC)</b>\n\n";
    $message .= "Silakan pilih panduan yang ingin Anda baca:";
    
    sendMessage($chat_id, $message, $reply_markup);
}

function handlePanduanCallback($telegram_id, $chat_id, $callback_data) {
    $user = isUserRegistered($telegram_id);
    
    if (!$user) {
        sendMessage($chat_id, "❌ Anda belum terdaftar dalam sistem.");
        return;
    }
    
    switch ($callback_data) {
        case 'panduan_user':
            sendPanduanUser($chat_id);
            break;
        case 'panduan_admin':
            if ($user['role'] == 'Admin') {
                sendPanduanAdmin($chat_id);
            } else {
                sendMessage($chat_id, "❌ Panduan Admin hanya tersedia untuk pengguna dengan role Admin.");
            }
            break;
        case 'panduan_token':
            sendPanduanToken($chat_id);
            break;
        case 'panduan_faq':
            sendPanduanFAQ($chat_id);
            break;
    }
}

function sendPanduanUser($chat_id) {
    $message = "👤 <b>PANDUAN PENGGUNA BOT AIC</b>\n\n";
    
    $message .= "🔸 <b>FITUR UTAMA:</b>\n\n";
    
    $message .= "📁 <b>NKL</b>\n";
    $message .= "• Menampilkan data yang ada di folder NKL\n";
    $message .= "• Klik tombol 'NKL' untuk melihat data\n\n";
    
    $message .= "📁 <b>NBR</b>\n";
    $message .= "• Menampilkan data yang ada di folder NBR\n";
    $message .= "• Klik tombol 'NBR' untuk melihat data\n\n";
    
    $message .= "📋 <b>Detail NKL</b>\n";
    $message .= "• Menampilkan data yang ada di folder Detail NKL\n";
    $message .= "• Data lebih lengkap dan terperinci\n\n";
    
    $message .= "📋 <b>Detail NBR</b>\n";
    $message .= "• Menampilkan data yang ada di folder Detail NBR\n";
    $message .= "• Data lebih lengkap dan terperinci\n\n";
    
    $message .= "📈 <b>TREND</b>\n";
    $message .= "• Menampilkan data yang ada di folder TREND\n";
    $message .= "• Analisis performa bisnis\n\n";
    
    $message .= "🎯 <b>16 Toko Fokus NBR</b>\n";
    $message .= "• Menampilkan data yang ada di folder 16 Toko Fokus NBR\n";
    $message .= "• Floor marking dan analisis performa\n\n";
    
    $message .= "ℹ️ <b>Info Akun</b>\n";
    $message .= "• Melihat informasi akun Anda\n";
    $message .= "• Detail profil dan role\n\n";
    
    $message .= "🔸 <b>CARA MENGGUNAKAN:</b>\n\n";
    $message .= "1️⃣ Ketik /start untuk memulai\n";
    $message .= "2️⃣ Pilih fitur menggunakan keyboard\n";
    $message .= "3️⃣ Bot akan menampilkan data sesuai permintaan\n";
    $message .= "4️⃣ Gunakan 'Menu Utama' untuk kembali\n\n";
    
    $message .= "💡 <b>TIPS:</b>\n";
    $message .= "• Semua fitur dapat diakses melalui keyboard\n";
    $message .= "• Data akan diperbarui secara real-time\n";
    $message .= "• Jika ada masalah, hubungi Super Admin (@lukhetler)\n";
    
    sendMessage($chat_id, $message);
}

function sendPanduanAdmin($chat_id) {
    $message = "⚙️ <b>PANDUAN ADMIN BOT AIC</b>\n\n";
    
    $message .= "🔸 <b>FITUR ADMIN:</b>\n\n";
    
    $message .= "➕ <b>Tambah Pengguna</b>\n";
    $message .= "• Mendaftarkan pengguna baru ke sistem\n";
    $message .= "• Input: Nama depan, nama belakang, Telegram ID, role\n";
    $message .= "• Role tersedia: User, Admin\n\n";
    
    $message .= "❌ <b>Hapus Pengguna</b>\n";
    $message .= "• Menghapus pengguna dari sistem\n";
    $message .= "• Input Telegram ID pengguna yang akan dihapus\n";
    $message .= "• Konfirmasi diperlukan sebelum penghapusan\n\n";
    
    $message .= "🔑 <b>Buat Token</b>\n";
    $message .= "• Membuat token untuk memberikan akses folder ke pengguna yang tidak terdaftar\n";
    $message .= "• Token berupa kode 8-12 karakter (huruf besar & angka)\n";
    $message .= "• Token dapat digunakan satu kali\n\n";
    $message .= "• Jika token belum digunakan dan melebihi 24 jam maka token tidak dapat digunakan lagi\n\n";
    
    $message .= "🔸 <b>LANGKAH MENAMBAH PENGGUNA:</b>\n\n";
    $message .= "1️⃣ Klik 'Tambah Pengguna'\n";
    $message .= "2️⃣ Masukkan nama depan\n";
    $message .= "3️⃣ Masukkan nama belakang\n";
    $message .= "4️⃣ Masukkan Telegram ID (angka unik user)\n";
    $message .= "5️⃣ Pilih role (User/Admin)\n";
    $message .= "6️⃣ Konfirmasi pendaftaran\n\n";
    
    $message .= "🔸 <b>LANGKAH MENGHAPUS PENGGUNA:</b>\n\n";
    $message .= "1️⃣ Klik 'Hapus Pengguna'\n";
    $message .= "2️⃣ Masukkan Telegram ID yang akan dihapus\n";
    $message .= "3️⃣ Konfirmasi penghapusan\n\n";
    
    $message .= "🔸 <b>LANGKAH MEMBUAT TOKEN:</b>\n\n";
    $message .= "1️⃣ Klik 'Buat Token'\n";
    $message .= "2️⃣ Pilih folder untuk token \n";
    $message .= "3️⃣ Token akan dibuat otomatis\n";
    $message .= "4️⃣ Bagikan token kepada pengguna yang tidak terdaftar\n\n";
    
    $message .= "⚠️ <b>PENTING:</b>\n";
    $message .= "• Hanya Admin yang dapat mengakses fitur ini\n";
    $message .= "• Telegram ID harus berupa angka\n";
    $message .= "• Hati-hati saat menghapus pengguna (tidak dapat dibatalkan)\n";
    $message .= "• Token memiliki masa berlaku tertentu\n";
    
    sendMessage($chat_id, $message);
}

function sendPanduanToken($chat_id) {
    $message = "🔑 <b>PANDUAN TOKEN REGISTRASI</b>\n\n";
    
    $message .= "🔸 <b>APA ITU TOKEN?</b>\n\n";
    $message .= "Token adalah kode unik untuk memberikan akses ke salah satu folder untuk pengguna yang tidak terdaftar di bot AIC.\n";
    $message .= "Token berupa kombinasi huruf besar dan angka (8-12 karakter).\n\n";
    
    $message .= "🔸 <b>CARA MENGGUNAKAN TOKEN:</b>\n\n";
    $message .= "1️⃣ Dapatkan token dari Admin\n";
    $message .= "2️⃣ Mulai chat dengan bot (/start)\n";
    $message .= "3️⃣ Bot akan meminta token jika belum terdaftar\n";
    $message .= "4️⃣ Kirim token yang Anda terima\n";
    $message .= "5️⃣ Bot akan memberikan file sesuai folder yang terintegrasi dengan token\n\n";
    
    $message .= "🔸 <b>CONTOH TOKEN:</b>\n\n";
    $message .= "<code>ABC123XYZ</code>\n";
    $message .= "<code>DEF456UVW</code>\n";
    $message .= "<code>GHI789RST</code>\n\n";
    
    $message .= "🔸 <b>KEUNTUNGAN TOKEN:</b>\n\n";
    $message .= "✅ Berguna untuk memberikan akses folder untuk eksternal divisi Inventory Control tanpa mendaftarkan pengguna lagi\n";
    $message .= "✅ Proses lebih cepat dan efisien\n";
    $message .= "✅ Token dapat dibuat sesuai kebutuhan\n";
    $message .= "✅ Kontrol akses yang lebih baik\n\n";
    
    $message .= "⚠️ <b>CATATAN PENTING:</b>\n\n";
    $message .= "• Token hanya dapat digunakan sekali\n";
    $message .= "• Token memiliki masa berlaku\n";
    $message .= "• Jaga kerahasiaan token Anda\n";
    $message .= "• Hubungi super admin (@lukhetler) jika token tidak valid\n\n";
    
    $message .= "❓ <b>MASALAH TOKEN:</b>\n\n";
    $message .= "• Token tidak valid: Hubungi admin untuk token baru\n";
    $message .= "• Token kadaluarsa: Minta token baru dari admin\n";
    $message .= "• Format salah: Pastikan token berupa huruf besar & angka\n";
    
    sendMessage($chat_id, $message);
}

function sendPanduanFAQ($chat_id) {
    $message = "❓ <b>FAQ (Frequently Asked Questions)</b>\n\n";
    
    $message .= "🔸 <b>PERTANYAAN UMUM:</b>\n\n";
    
    $message .= "<b>Q: Bagaimana cara mendaftar ke bot?</b>\n";
    $message .= "A: Minta minta admin mendaftarkan Anda secara langsung.\n\n";
    
    $message .= "<b>Q: Bagaimana cara melihat Telegram ID saya?</b>\n";
    $message .= "A: Chat ke @IC_CekIDBot atau minta bantuan admin untuk mengetahui Telegram ID Anda.\n\n";
    
    $message .= "<b>Q: Apakah data yang ditampilkan real-time?</b>\n";
    $message .= "A: Ya, data diperbarui secara real-time dari sistem.\n\n";
    
    $message .= "<b>Q: Siapa yang bisa menjadi Admin?</b>\n";
    $message .= "A: Admin ditentukan oleh sistem dan memiliki akses khusus untuk mengelola pengguna.\n\n";
    
    $message .= "<b>Q: Bagaimana jika lupa password?</b>\n";
    $message .= "A: Bot tidak menggunakan password, akses berdasarkan Telegram ID yang terdaftar.\n\n";
    
    $message .= "🔸 <b>MASALAH TEKNIS:</b>\n\n";
    
    $message .= "<b>Q: Bot tidak merespon?</b>\n";
    $message .= "A: Coba ketik /start atau hubungi super admin (@lukhetler) jika masalah berlanjut.\n\n";
    
    $message .= "<b>Q: Data tidak muncul?</b>\n";
    $message .= "A: Pastikan Anda sudah terdaftar dan memiliki akses ke fitur tersebut.\n\n";
    
    $message .= "<b>Q: Error saat menggunakan fitur?</b>\n";
    $message .= "A: Screenshot error dan laporkan ke super admin (@lukhetler) untuk diperbaiki.\n\n";
    
    $message .= "🔸 <b>KONTAK BANTUAN:</b>\n\n";
    $message .= "Jika Anda mengalami masalah yang tidak tercantum di FAQ, silakan hubungi super admin (@lukhetler) untuk mendapatkan bantuan lebih lanjut.\n\n";
    
    $message .= "📱 Bot ini dikembangkan untuk memudahkan akses data IC (Versi 0.0.1).\n";
    $message .= "Gunakan dengan bijak dan sesuai kebutuhan pekerjaan.\n";
    
    sendMessage($chat_id, $message);
}
?>