<?php
// hapus-pengguna.php
require_once 'config.php';

function handleHapusPengguna($telegram_id, $chat_id, $message_text) {
    // Cek apakah user adalah admin
    $user = isUserRegistered($telegram_id);
    if (!$user || $user['role'] != 'Admin') {
        sendMessage($chat_id, "❌ Anda tidak memiliki akses untuk menghapus pengguna.");
        return;
    }
    
    $temp_data = getTemporaryData($telegram_id);
    
    // Step 1: Mulai proses hapus pengguna
    if ($message_text === '❌ Hapus Pengguna') {
        // Tampilkan daftar pengguna yang bisa dihapus
        $db = getDB();
        $stmt = $db->prepare("SELECT telegram_id, nama_depan, nama_belakang, role FROM users WHERE telegram_id != ? ORDER BY nama_depan");
        $stmt->execute([$telegram_id]); // Exclude admin yang sedang login
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        if (empty($users)) {
            sendMessage($chat_id, "❌ Tidak ada pengguna lain yang terdaftar dalam sistem.");
            return;
        }
        
        $message = "👥 <b>Daftar Pengguna Terdaftar:</b>\n\n";
        foreach ($users as $index => $user_data) {
            $message .= ($index + 1) . ". {$user_data['nama_depan']} {$user_data['nama_belakang']} ({$user_data['role']})\n";
            $message .= "   ID: {$user_data['telegram_id']}\n\n";
        }
        $message .= "📝 Silakan masukkan <b>Telegram ID</b> pengguna yang ingin dihapus:";
        
        // Simpan data sementara
        saveTemporaryData($telegram_id, [
            'step' => 'hapus_pengguna_input_id',
            'users_list' => $users
        ]);
        
        sendMessage($chat_id, $message);
    }
    // Step 2: Terima input Telegram ID
    else if (!empty($temp_data) && $temp_data['step'] === 'hapus_pengguna_input_id') {
        $target_telegram_id = trim($message_text);
        
        // Validasi input adalah angka
        if (!is_numeric($target_telegram_id)) {
            sendMessage($chat_id, "❌ Format Telegram ID tidak valid. Harap masukkan angka yang benar.");
            return;
        }
        
        // Cek apakah pengguna ada di database
        $db = getDB();
        $stmt = $db->prepare("SELECT * FROM users WHERE telegram_id = ?");
        $stmt->execute([$target_telegram_id]);
        $target_user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$target_user) {
            sendMessage($chat_id, "❌ Pengguna dengan Telegram ID tersebut tidak ditemukan.");
            return;
        }
        
        // Tidak bisa menghapus diri sendiri
        if ($target_telegram_id == $telegram_id) {
            sendMessage($chat_id, "❌ Anda tidak dapat menghapus akun Anda sendiri.");
            return;
        }
        
        // Konfirmasi penghapusan
        $confirm_message = "⚠️ <b>Konfirmasi Penghapusan</b>\n\n";
        $confirm_message .= "Anda akan menghapus pengguna:\n";
        $confirm_message .= "👤 Nama: {$target_user['nama_depan']} {$target_user['nama_belakang']}\n";
        $confirm_message .= "🆔 ID Telegram: {$target_user['telegram_id']}\n";
        $confirm_message .= "👑 Role: {$target_user['role']}\n\n";
        $confirm_message .= "⚠️ <b>PERINGATAN:</b> Tindakan ini tidak dapat dibatalkan!\n\n";
        $confirm_message .= "Apakah Anda yakin ingin menghapus pengguna ini?";
        
        // Simpan data sementara untuk konfirmasi
        saveTemporaryData($telegram_id, [
            'step' => 'hapus_pengguna_konfirmasi',
            'target_user' => $target_user
        ]);
        
        // Buat inline keyboard untuk konfirmasi
        $inline_keyboard = [
            [
                ['text' => '✅ Ya, Hapus', 'callback_data' => 'confirm_delete'],
                ['text' => '❌ Batal', 'callback_data' => 'cancel_delete']
            ]
        ];
        
        $reply_markup = [
            'inline_keyboard' => $inline_keyboard
        ];
        
        sendMessage($chat_id, $confirm_message, $reply_markup);
    }
}

function handleConfirmDelete($telegram_id, $chat_id, $callback_data) {
    $temp_data = getTemporaryData($telegram_id);
    
    if (empty($temp_data) || $temp_data['step'] !== 'hapus_pengguna_konfirmasi') {
        sendMessage($chat_id, "❌ Sesi penghapusan tidak valid atau telah berakhir.");
        return;
    }
    
    if ($callback_data === 'confirm_delete') {
        $target_user = $temp_data['target_user'];
        
        try {
            $db = getDB();
            $stmt = $db->prepare("DELETE FROM users WHERE telegram_id = ?");
            $result = $stmt->execute([$target_user['telegram_id']]);
            
            if ($result) {
                // Hapus data sementara
                clearTemporaryData($telegram_id);
                
                $success_message = "✅ <b>Pengguna berhasil dihapus!</b>\n\n";
                $success_message .= "👤 Nama: {$target_user['nama_depan']} {$target_user['nama_belakang']}\n";
                $success_message .= "🆔 ID Telegram: {$target_user['telegram_id']}\n";
                $success_message .= "📅 Dihapus pada: " . date('d M Y H:i') . "\n\n";
                $success_message .= "Pengguna tersebut tidak lagi memiliki akses ke bot ini.";
                
                sendMessage($chat_id, $success_message);
            } else {
                sendMessage($chat_id, "❌ Gagal menghapus pengguna. Silakan coba lagi nanti.");
            }
        } catch (Exception $e) {
            sendMessage($chat_id, "❌ Terjadi kesalahan saat menghapus pengguna: " . $e->getMessage());
        }
    } else if ($callback_data === 'cancel_delete') {
        // Hapus data sementara
        clearTemporaryData($telegram_id);
        
        sendMessage($chat_id, "❌ Penghapusan pengguna dibatalkan.");
    }
}
?>