<?php
// broadcast.php - Fitur Broadcast Message untuk Admin
require_once 'config.php';

function handleBroadcast($telegram_id, $chat_id, $message) {
    // Cek apakah user adalah admin
    $role = getUserRole($telegram_id);
    
    if ($role !== 'Admin') {
        sendMessage($chat_id, "❌ Maaf, fitur ini hanya untuk Admin.");
        return;
    }
    
    $temp_data = getTemporaryData($telegram_id);
    
    // Jika baru memulai broadcast
    if (!isset($temp_data['step']) && (isset($message['text']) && 
        ($message['text'] === '📢 Broadcast Message' || $message['text'] === 'Broadcast Message'))) {
        
        $temp_data = [
            'step' => 'waiting_broadcast_content',
            'feature' => 'broadcast'
        ];
        saveTemporaryData($telegram_id, $temp_data);
        
        $info_text = "📢 <b>Broadcast Message</b>\n\n";
        $info_text .= "Silakan kirim pesan atau gambar yang ingin Anda broadcast ke semua pengguna.\n\n";
        $info_text .= "ℹ️ <b>Catatan:</b>\n";
        $info_text .= "• Anda bisa mengirim teks saja\n";
        $info_text .= "• Anda bisa mengirim gambar dengan atau tanpa caption\n";
        $info_text .= "• Pesan akan dikirim ke semua pengguna terdaftar\n\n";
        $info_text .= "Ketik 'Batal' untuk membatalkan.";
        
        sendMessage($chat_id, $info_text);
        return;
    }
    
    // Jika user ingin membatalkan
    if (isset($message['text']) && strtolower(trim($message['text'])) === 'batal') {
        clearTemporaryData($telegram_id);
        sendMessage($chat_id, "❌ Broadcast dibatalkan.");
        return;
    }
    
    // Jika sedang menunggu konten broadcast
    if (isset($temp_data['step']) && $temp_data['step'] === 'waiting_broadcast_content') {
        
        // Tampilkan konfirmasi
        $confirm_text = "📢 <b>Konfirmasi Broadcast</b>\n\n";
        
        if (isset($message['photo'])) {
            $caption = isset($message['caption']) ? $message['caption'] : "(Tanpa caption)";
            $confirm_text .= "🖼️ Anda akan mengirim gambar dengan caption:\n";
            $confirm_text .= "<i>" . htmlspecialchars($caption) . "</i>\n\n";
            
            // Simpan data foto
            $photo = end($message['photo']); // Ambil foto dengan resolusi tertinggi
            $temp_data['photo_file_id'] = $photo['file_id'];
            $temp_data['caption'] = $message['caption'] ?? '';
            
        } else if (isset($message['text'])) {
            $confirm_text .= "💬 Anda akan mengirim pesan:\n";
            $confirm_text .= "<i>" . htmlspecialchars($message['text']) . "</i>\n\n";
            
            // Simpan data teks
            $temp_data['broadcast_text'] = $message['text'];
        } else {
            sendMessage($chat_id, "❌ Format tidak didukung. Silakan kirim teks atau gambar saja.");
            return;
        }
        
        // Hitung jumlah pengguna
        $db = getDB();
        $stmt = $db->query("SELECT COUNT(*) as total FROM users");
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        $total_users = $result['total'];
        
        $confirm_text .= "👥 Pesan akan dikirim ke <b>{$total_users} pengguna</b>\n\n";
        $confirm_text .= "Apakah Anda yakin?";
        
        $temp_data['step'] = 'confirm_broadcast';
        saveTemporaryData($telegram_id, $temp_data);
        
        $inline_keyboard = [
            'inline_keyboard' => [
                [
                    ['text' => '✅ Ya, Kirim', 'callback_data' => 'confirm_broadcast'],
                    ['text' => '❌ Batal', 'callback_data' => 'cancel_broadcast']
                ]
            ]
        ];
        
        sendMessage($chat_id, $confirm_text, $inline_keyboard);
        return;
    }
}

function handleBroadcastCallback($telegram_id, $chat_id, $callback_data) {
    $temp_data = getTemporaryData($telegram_id);
    
    if ($callback_data === 'cancel_broadcast') {
        clearTemporaryData($telegram_id);
        sendMessage($chat_id, "❌ Broadcast dibatalkan.");
        return;
    }
    
    if ($callback_data === 'confirm_broadcast' && isset($temp_data['step']) && 
        $temp_data['step'] === 'confirm_broadcast') {
        
        $db = getDB();
        
        // Ambil semua user
        $stmt = $db->query("SELECT telegram_id, nama_depan FROM users");
        $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        $success_count = 0;
        $failed_count = 0;
        
        sendMessage($chat_id, "📤 Sedang mengirim broadcast...");
        
        foreach ($users as $user) {
            try {
                $user_chat_id = $user['telegram_id'];
                
                // Kirim foto jika ada
                if (isset($temp_data['photo_file_id'])) {
                    $result = sendPhoto($user_chat_id, $temp_data['photo_file_id'], $temp_data['caption'] ?? '');
                } 
                // Kirim teks jika ada
                else if (isset($temp_data['broadcast_text'])) {
                    $result = sendMessage($user_chat_id, $temp_data['broadcast_text']);
                }
                
                if ($result && isset($result['ok']) && $result['ok']) {
                    $success_count++;
                } else {
                    $failed_count++;
                }
                
                // Delay untuk menghindari rate limit
                usleep(50000); // 50ms delay
                
            } catch (Exception $e) {
                $failed_count++;
                error_log("Broadcast error to user {$user_chat_id}: " . $e->getMessage());
            }
        }
        
        clearTemporaryData($telegram_id);
        
        $result_text = "✅ <b>Broadcast Selesai!</b>\n\n";
        $result_text .= "📊 <b>Statistik:</b>\n";
        $result_text .= "✅ Berhasil: {$success_count}\n";
        $result_text .= "❌ Gagal: {$failed_count}\n";
        $result_text .= "👥 Total: " . ($success_count + $failed_count);
        
        sendMessage($chat_id, $result_text);
    }
}

function sendPhoto($chat_id, $photo_file_id, $caption = '') {
    $data = [
        'chat_id' => $chat_id,
        'photo' => $photo_file_id,
        'parse_mode' => 'HTML'
    ];
    
    if ($caption) {
        $data['caption'] = $caption;
    }
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, API_URL . 'sendPhoto');
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    
    $response = curl_exec($ch);
    curl_close($ch);
    
    return json_decode($response, true);
}
?>